varying vec4 position;
varying vec4 texcoord;
varying vec3 normal;
uniform sampler2D texture;
uniform float freq;
uniform vec4 basecolor;

void main()
{
  vec4 color = texture2D(texture, texcoord.st);
  float c = max((mod( length(position-vec4(0.0, -500.0, 0.0, 0.0))-freq*5.0, 2500.0)-2000.0)/500.0, 0.0);
  color.xyz = basecolor.xyz*vec3(c,c,c);
  if(abs(normal.y) > 0.99) {
    color.w*=0.3;
  }
  gl_FragColor = color;
}
