uniform sampler2D texture;
uniform vec2 center;
uniform vec2 direction;
uniform float strength;

const float width = 640.0;
const float height = 480.0;

void main()
{
  vec2 pos = gl_TexCoord[0].st*vec2(width, height);
  vec2 diff = pos-center;
  float dist = length(diff);

  float d = dot(direction, normalize(diff));
  float range = 250.0*((d+1.0)/2.0)+30;

  float q = pow(max(0.0, 1.0-(dist/range)), 2.0);
  vec2 dst = vec2(1.0/width, 1.0/height)*(pos-(diff*vec2(q*strength)));
  vec4 color = texture2D(texture, dst);

//  color = vec4(q*strength);
  gl_FragColor = color;
}
